package gov.va.vamf.scheduling.direct.ical;

import com.agilex.healthcare.directscheduling.domain.BookedAppointment;
import com.agilex.healthcare.directscheduling.domain.BookedAppointments;
import com.agilex.healthcare.utility.NullChecker;
import net.fortuna.ical4j.model.*;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.*;
import net.fortuna.ical4j.util.UidGenerator;

import java.net.SocketException;
import java.util.Date;

public class ICalHelper {

    public static Calendar transformAppointmentsToIcal(BookedAppointments appointments) {
        Calendar icsCalendar = new Calendar();
        setUpCalendar(icsCalendar);

        for (BookedAppointment appointment : appointments) {
            VEvent appointmentEvent = convertAppointmentToVEvent(appointment);
            icsCalendar.getComponents().add(appointmentEvent);
        }

        return icsCalendar;
    }

    private static VEvent convertAppointmentToVEvent(BookedAppointment appointment) {

        DateTime start = new DateTime(appointment.getAppointmentTime());
        DateTime end = new DateTime(calculateEndDate(appointment));
        String summary = appointment.getBookingNote();

        VEvent appointmentEvent = new VEvent(start, end, summary);
        addAlarmToVEvent(appointment, appointmentEvent);
        PropertyList properties = appointmentEvent.getProperties();
        properties.add(generateUid());
        properties.add(Clazz.PRIVATE);
        properties.add(new Location(appointment.getClinic().getName()));
        properties.add(new Description(appointment.getCurrentStatus()));

        return appointmentEvent;
    }

    private static void setUpCalendar(Calendar calendar) {
        calendar.getProperties().add(new ProdId("-//Events Calendar//iCal4j 1.0//EN"));
        calendar.getProperties().add(CalScale.GREGORIAN);
        calendar.getProperties().add(Version.VERSION_2_0);
    }

    private static Date calculateEndDate(BookedAppointment appointment) {
        return calculateEndDateByDuration(appointment);
    }

    private static void addAlarmToVEvent(BookedAppointment appointment, VEvent event) {
//		if (appointment.getAlarmOffset() != null) {
//			int minuteOffset = appointment.getAlarmOffset();
//			VAlarm alarm = new VAlarm(new Dur(0, 0, minuteOffset, 0));
//			ComponentList componentList = event.getAlarms();
//			componentList.add(alarm);
//		}
    }

    private static Date calculateEndDateByDuration(BookedAppointment appt) {
        java.util.Calendar cal = java.util.Calendar.getInstance();
        cal.setTime(appt.getAppointmentTime());

        Integer appointmentDuration = NullChecker.isNotNullish(appt.getAppointmentLength()) ?
            Integer.parseInt(appt.getAppointmentLength()) : 30;

        cal.add(java.util.Calendar.MINUTE, appointmentDuration);

        return cal.getTime();
    }

    private static Uid generateUid() {
        UidGenerator ug;
        try {
            ug = new UidGenerator("uidGen");
        } catch (SocketException e) {
            throw new RuntimeException("Could not generate UID via UidGenerator. ", e);
        }
        return ug.generateUid();
    }
}

